package edu.duke.cs.prof.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class WeeklyMainFactory {
	private BufferedReader specs;
	private File myWeeklyGeneric,myWeeklyMain;
	private String WEEKLY_CLASS;
	private String WEEKLY_FUNCTION;
	private int paramNum;
	private ArrayList inputTypes;
	private String outputType, limitString;
	
	private final boolean DEBUG = true;
	
	public WeeklyMainFactory(String path,String specFile) throws NumberFormatException, IOException{		
		FileReader specFileReader = new FileReader(new File(path +
				File.separator + specFile));
		specs = new BufferedReader(specFileReader);
		
		myWeeklyGeneric = new File(path + File.separator +
				"WeeklyGeneric.java");
		
		myWeeklyMain = new File(path + File.separator+
				"WeeklyMain.java");
		
		WEEKLY_CLASS = specs.readLine();
		WEEKLY_FUNCTION = specs.readLine();
		
		paramNum = Integer.parseInt(specs.readLine());
		inputTypes = new ArrayList(paramNum);
		for(int i = 0; i < paramNum; i++)
		{
			inputTypes.add(specs.readLine());
		}
		outputType = specs.readLine();
		
		if (DEBUG){
			System.out.println("weekly class " + WEEKLY_CLASS);
			System.out.println("weekly function " + WEEKLY_FUNCTION);
			System.out.println("param num" + paramNum);
			
			for (int k=0;k<inputTypes.size();k++){
				System.out.println("input type " + ((String)inputTypes.get(k)));
			}
			
			System.out.println("output type " + outputType);
		}
	}
	
	public void writeSpecific() throws IOException{
		FileReader generic = new FileReader(myWeeklyGeneric);
		FileWriter main = new FileWriter(myWeeklyMain);
		
		BufferedReader in = new BufferedReader(generic);
		String currentLine = new String();
	
		boolean inSpecifics = false;
		boolean inCall = false;
		boolean inOutputSpec = false;
		boolean inVarSpec = false;
		boolean inOutputInit = false;
		boolean inLimitCheck = false;
		boolean inPrintVars = false;
		boolean inExpected = false;
		boolean inExpectedVar = false;
		
		currentLine = in.readLine();
		
		while(currentLine != null)
		{
			//TODO: make sure it doesnt write more than once
			if(currentLine.equals("public class WeeklyGeneric"))
				main.write("public class WeeklyMain\n");
			if(currentLine.equals("//output"))
			{
				inOutputSpec = !inOutputSpec;
				inSpecifics = !inSpecifics;
			}			
			if(currentLine.equals("//vars"))
			{
				inVarSpec = !inVarSpec;
				inSpecifics = !inSpecifics;
			}			
			if(currentLine.equals("//outputinit"))
			{
				inOutputInit = !inOutputInit;
				inSpecifics = !inSpecifics;
			}			
			if(currentLine.equals("//call"))
			{
				inCall = !inCall;
				inSpecifics = !inSpecifics;
			}			
			if(currentLine.equals("//limitcheck"))
			{
				inLimitCheck = !inLimitCheck;
				inSpecifics = !inSpecifics;
			}			
			if(currentLine.equals("//printvars"))
			{
				inPrintVars = !inPrintVars;
				inSpecifics = !inSpecifics;
			}			
			if(currentLine.equals("//expected"))
			{
				inExpected = !inExpected;
				inSpecifics = !inSpecifics;
			}	
			if(currentLine.equals("//expectedvar"))
			{
				inExpectedVar = !inExpectedVar;
				inSpecifics = !inSpecifics;
			}	
				
			if(!inSpecifics)
				//writes line of what is in the generic file and is no different
				//for any particular weekly.
				main.write(currentLine + "\n");
			
			if(inOutputSpec)
			{
				main.write("static " + outputType + " result;\n");
			}
			if(inVarSpec)
			{
				main.write("final " + WEEKLY_CLASS + " weeklyObj = new " + WEEKLY_CLASS + "();\n");
				
				for(int i = 0; i < paramNum; i++)
				{
					main.write("final " + inputTypes.get(i) + " var" + i + " = p." + parseCall((String)inputTypes.get(i)) + ";\n");
				}
			}
			if(inOutputInit)
			{
				if(outputType.equals("int"))
					limitString = "Integer.MIN_VALUE";
				if(outputType.equals("double"))
					limitString = "Double.MIN_VALUE";
				else
					limitString = "null";
				
				main.write("result = " + limitString + ";\n");
			}
			if(inLimitCheck)
			{
				main.write("if (! done || result == " + limitString + "){\n");
			}
			if(inPrintVars)
			{
				for(int i = 0; i < paramNum; i++)
				{
					if(i > 0)
						main.write("System.out.print(\", \");\n");
					
					main.write("p.print(var" + i + ");\n");
				}
			}
			if(inExpected)
			{
				String expectedString = "System.out.print(\"fail expected \");\n p.print(expected);\n " +
						"System.out.print(\" got \");\n p.print(result);\n System.out.print(\" : \")\n;";
				
				main.write(expectedString);
			}
			if(inExpectedVar)
			{
				main.write(outputType + " expected = p.match(result);\n");
			}
			if(inCall)
			{
				String callString = "result = weeklyObj." + WEEKLY_FUNCTION + "(";
				for(int k = 0; k < paramNum; k++)
				{
					if(k > 0)
						callString += ", ";
					callString += "var" + k;
				}
				callString += ");\n";
				main.write(callString);
			}
			else
				main.write(currentLine);
			
			currentLine = in.readLine();
		}	
		main.close();
	}
	
	private String parseCall(String typeName)
	{
		if(typeName.equals("int"))
			return "getInt()";
		if(typeName.equals("double"))
			return "getDouble()";
		if(typeName.equals("int[]"))
			return "parseVI()";
		if(typeName.equals("String[]"))
			return "parseVS()";
		if(typeName.equals("double[]"))
			return "parseVD()";
		else
			return "getString()";
	}
}
