'''
Created on Feb 1, 2018
Modified Sept 19, 2019

@author: ola, ksm, yesenia, alexbendeck
'''
import turtle, random


def drawSquare(turt, size):
    """
    turt (Turtle) - a turtle object
    size (float) - the length of one side of the square drawn

    Creates a square of the specified size.
    """
    turt.begin_fill()  # Mark the beginning of the shape to fill
    for _ in range(4):
        turt.forward(size)
        turt.right(90)

    turt.end_fill()   # Mark the end of the shape to fill


def drawRectangle(turt, size):
    """
    turt (Turtle) - a turtle object
    size (float) - the size of the rectangle drawn

    Creates a rectangle of the specified size.
    """
    turt.begin_fill()
    for side in range(4):
        if side % 2 == 0:  # Even sides are longer
            turt.forward(size)
        else:  # Odd sides are shorter
            turt.forward(size/2)
        turt.right(90)

    turt.end_fill()


def drawMany(turt, func):
    """
    turt (Turtle) - a turtle object
    func (function) - function that takes a turtle and size and draws something

    Calls the function func the number of times
    specified by user input.
    """
    width = 1000
    height = 500

    turt.speed(0)

    num = input("number of elements> ")  # Get user input
    num = int(num)  # Convert user input to an integer

    for _ in range(num):
        r = random.randint(0,255)
        g = random.randint(0,255)
        b = random.randint(0,255)

        turt.penup()
        turt.color(r, g, b)

        x = random.randint(-width//2, width//2)
        y = random.randint(-height//2, height//2)

        turt.setposition(x, y)

        func(turt, 40)


if __name__ == '__main__':
    win = turtle.Screen()
    win.colormode(255)
    t = turtle.Turtle()

    drawMany(t, drawSquare)
    #drawMany(t, drawRectangle)

    win.exitonclick()
