'''
Created on Jan 31, 2018
Modified Sept 19, 2019

@author: ola, ksm, yesenia, alexbendeck
'''
import turtle

def drawCircle(turt, size):
    """
    turt (Turtle) - a turtle object
    size (float) - the size of the circle

    Create a circle with specified radius
    Creates a circle at turt's current position
    When finished turt's pen will be up
    """
    turt.pendown()
    turt.begin_fill()
    turt.circle(size)
    turt.end_fill()
    turt.penup()


def drawSnowman(turt, size):
    """
    turt (Turtle) - a turtle object
    size (float) - the size of the biggest circle in the snowman

    Create a snowperson using the turtle turt
    that's a parameter
    
    Leaves turtle hidden at end
    BUGBUG: should turtle be at same position when done?
    """
    turt.color("red")
    drawCircle(turt,size)
    
    turt.color("blue")
    turt.setposition(turt.xcor(), turt.ycor()+2*size)
    size = size//2
    drawCircle(turt,size)
    
    turt.color("green")
    turt.setposition(turt.xcor(), turt.ycor()+2*size)
    size = size//2
    drawCircle(turt,size)
    
    turt.hideturtle()


def drawMany(turt, func):
    """
    turt (Turtle) - a turtle object
    func (function) - function that takes a turtle and size and draws something

    Draw several "things" in a row
    """
    turt.speed(0)
    width = 1000
    size = 60
    xcoord = -width/2 + size

    for _ in range(8):
        turt.penup()
        turt.setx(xcoord)
        turt.sety(0)
        func(turt,size)
        xcoord = xcoord + 2*size + 10


if __name__ == '__main__':
    win = turtle.Screen()
    t = turtle.Turtle()
    drawMany(t, drawSnowman)  # Try changing drawSnowman to drawCircle
    win.exitonclick()
